let mode = 1; //描くモード

function setup() {
  createCanvas(600, 600); //ウィンドウサイズの指定
  background(203, 231, 226); //背景色を指定して1回だけ塗る。

  fill(198, 156, 109);
  noStroke();
  angleMode(DEGREES);
  arc(300, 300, 500, 500, 0, 180, PIE);

  fill(166, 124, 82);
  noStroke();
  ellipse(300, 300, 500, 300);

  strokeWeight(20); //線の太さを指定する
  noFill();
  stroke(166, 124, 82);
  angleMode(DEGREES);
  arc(300, 300, 500, 500, 180, 0, PIE);

  strokeWeight(1); //線の太さを元に戻す

  //説明文
  fill(114, 164, 186);
  noStroke();
  text("１か２か３のキーを押すとモードが変わります", 20, 580);
}

function draw() {
  // background(0, 0, 0); //背景色を指定して1回だけ塗る。
  //if (mouseIsPressed == true) {

  if (mouseIsPressed) {
    if (mode == 1) {
      fill(220, 74, 87);
      noStroke();
      circle(mouseX, mouseY, random(10, 130));
      stroke(96, 56, 19);
    }
    if (mode == 2) {
      fill(252, 238, 33);
      noStroke();
      circle(mouseX, mouseY, random(10, 130));
    }
    if (mode == 3) {
      if (mouseIsPressed == true) {
        fill(135, 71, 48); //塗りの色を指定する
        noStroke(); //線を「なし」にする。Sが大文字だから気を付ける！
        circle(mouseX, mouseY, 5); //マウスの位置に線を書く。
        line(pmouseX, pmouseY, mouseX, mouseY);
      }
    }
  }
}

function mousePressed() {
  //マウスのボタンが押し下げられた時の処理
}

function mouseReleased() {
  //マウスのボタンが離された時の処理
}

function keyPressed() {
  if (key == "1") {
    mode = 1;
  }
  if (key == "2") {
    mode = 2;
  }
  if (key == "3") {
    mode = 3;
  }

  if (key == "s") {
    saveCanvas();
  }
}
