let num = 30; //配列の数として使う変数
let x = new Array(num); //Xという配列を作る
let y = new Array(num); //yという配列を作る
let susumuX = new Array(num);
let susumuY = new Array(num);
function setup() {
  createCanvas(600, 600); //ウィンドウサイズの指定
  background(0, 0, 0); //背景色を指定して1回だけ塗る。
  for (let i = 0; i < num; i = i + 1) {
    x[i] = random(0, width); //0からwidthの間でランダム
    y[i] = random(0, height);
    susumuX[i] = random(2, 3);
    susumuY[i] = random(5, 2);
  }
}

function draw() {
  background(0, 0, 0); //背景色を指定して1回だけ塗る。
  for (let i = 0; i < num; i = i + 1) {
    noStroke();
    fill(255, 255, 255);
    let kyori = dist(mouseX, mouseY, x[i], y[i]);
    if (kyori < 50) {
      noFill();
      stroke(255, 255, 255);
      let kakudo = atan2(mouseY - y[i], mouseX - x[i]);
      susumuX[i] = susumuX[i] + cos(kakudo);
      susumuY[i] = susumuY[i] + sin(kakudo);
    }
    circle(x[i], y[i], 100);
    x[i] = x[i] + susumuX[i];
    if (x[i] > width || x[i] < 0) {
      susumuX[i] = susumuX[i] * -1;
    }
    y[i] = y[i] + susumuY[i];
    if (y[i] > height || y[i] < 0) {
      susumuY[i] = susumuY[i] * -1;
    }
  }
}

function mousePressed() {
  //マウスのボタンが押し下げられた時の処理
}

function mouseReleased() {
  //マウスのボタンが離された時の処理
}

function keyPressed() {
  if (key == "s") {
    saveCanvas();
  }
}
