//連想配列
let mojis = [
  { name: "mickey", category: "mouse" },
  { name: "minnie", category: "mouse" },
  { name: "donald", category: "duck" },
  { name: "daisy", category: "duck" },
  { name: "pluto", category: "dog" },
  { name: "goofy", category: "dog" },
  { name: "max", category: "dog" },
  { name: "chip", category: "squirrel" },
  { name: "dale", category: "squirrel" },
  { name: "clarice", category: "squirrel" },
];
let x = new Array(mojis.length);
let y = new Array(x.length);

function setup() {
  createCanvas(600, 600); //ウィンドウサイズの指定
  background(0, 0, 0); //背景色を指定して1回だけ塗る。
  for (let i = 0; i < mojis.length; i = i + 1) {
    let angle = (TWO_PI / mojis.length) * i;
    let r = 100;
    x[i] = 300 + r * cos(angle);
    y[i] = 300 + r * sin(angle);
    circle(x[i], y[i], 30);
  }
}

function draw() {
  // background(0, 0, 0); //背景色を指定して1回だけ塗る。
  for (let i = 0; i < mojis.length; i = i + 1) {
    if (mojis[i].category == "mouse") {
      noStroke();
      fill(255, 255, 255);
      circle(x[i], y[i], 50);
    }
    if (mojis[i].category == "duck") {
      noStroke();
      fill(255, 0, 255);
      circle(x[i], y[i], 50);
    }
    if (mojis[i].category == "dog") {
      noStroke();
      fill(0, 255, 255);
      circle(x[i], y[i], 50);
    }
    if (mojis[i].category == "squirrel") {
      noStroke();
      fill(255, 255, 0);
      circle(x[i], y[i], 50);
    }
    textSize(8);
    fill(0, 0, 0);
    textAlign(CENTER, CENTER);
    text(mojis[i].name, x[i], y[i]);
  }
}

function mousePressed() {
  //マウスのボタンが押し下げられた時の処理
}

function mouseReleased() {
  //マウスのボタンが離された時の処理
}

function keyPressed() {
  if (key == "s") {
    saveCanvas();
  }
}
