let x = 300;
let y = 300;
let speedX = 8; // スピードを大幅にUP
let speedY = 6;
let iroMode = 1;

function setup() {
  createCanvas(600, 600);
  background(0);
}

function draw() {
  background(0, 30); // 少しだけ透明度を上げて残像感UP

  noStroke();

  let r, g, b;
  if (iroMode == 1) {
    r = random(200, 255);
    g = random(50);
    b = random(50);
  } else if (iroMode == 2) {
    r = random(50);
    g = random(200, 255);
    b = random(50);
  } else if (iroMode == 3) {
    r = random(50);
    g = random(50);
    b = random(200, 255);
  }

  fill(r, g, b, 180); // 少し透明に
  ellipse(x, y, 80 + random(-8, 8), 80 + random(-8, 8));

  // 動き
  background(0, 0, 0, 10); //背景色を指定して1回だけ塗る。
  noFill();
  stroke(255, 0, 0);
  circle(x, y, 100);
  x = x + speedX; //「x」に「speedX」の値を足す
  y = y + speedY; //「y」に「speedY」の値を足す
  if (x > 600) {
    speedX = speedX * -1;
  }
  if (x < 0) {
    speedX = speedX * -1;
  }
  if (y > 600) {
    speedY = speedY * -1;
  }
  if (y < 0) {
    speedY = speedY * -1;
  }
  circle(mouseX, mouseY, 10);
}

function mousePressed() {
  //マウスのボタンが押し下げられた時の処理
  circle(mouseX, mouseY, 100);
}

function keyPressed() {
  if (key === "1") iroMode = 1;
  if (key === "2") iroMode = 2;
  if (key === "3") iroMode = 3;
  if (keyCode == UP_ARROW) {
    speedY = speedY - 5;
  }
  if (keyCode == DOWN_ARROW) {
    speedY = speedY + 5;
  }
  if (key === "s") saveCanvas();
}
