let x = 300;
let y = 300;
let r = 100;
let dragging = false;

function setup() {
  createCanvas(600, 600); //ウィンドウサイズの指定
  background(0, 0, 0); //背景色を指定して1回だけ塗る。
  colorMode(HSB);
}

function draw() {
  // background(0, 0, 0); //背景色を指定して1回だけ塗る。
  background(0, 0, 0);
  noStroke();
  fill(120, 150, 65);

  let kyori = dist(x, y, mouseX, mouseY);
  if (kyori < r) {
    fill(random(360), 50, random(100));
    r += 1;
  } else {
    r = r + (100 - r) / 20.0; //ゆっくり戻す公式みたいなもの
  }
  if (dragging == true) {
    fill(255, 255, 100);
    x = x + (mouseX - x) / 20.0;
    y = y + (mouseY - y) / 20.0;
  }
  if (kyori < r) {
    circle(x + random(-10, 10), y + random(-20, 20), r * 2);
    //このランダムのところを小さくすればするほど小刻みな揺れになる
  } else {
    circle(x, y, r * 2);
  }
}

function mousePressed() {
  //マウスのボタンが押し下げられた時の処理
  dragging = false;
  let kyori = dist(x, y, mouseX, mouseY);
  if (kyori < r) {
    dragging = true;
  }
}

function mouseReleased() {
  //マウスのボタンが離された時の処理
  dragging = false;
}

function keyPressed() {
  if (key == "s") {
    saveCanvas();
  }
}
