let x = 300;
let y = 300;
let r = 100;
let dragging = false; //ドラッグ中か判定

function setup() {
  createCanvas(600, 600); //ウィンドウサイズの指定
  background(0, 0, 0); //背景色を指定して1回だけ塗る。
}

function draw() {
  background(0, 0, 0);
  noStroke();
  fill(0, 200, 100);

  let kyori = dist(x, y, mouseX, mouseY);
  if (kyori < r) {
    r += 1;
  } else {
    r = r + (100 - r) / 30.0; //円の半径をふわっと元に戻す
  }

  if (dragging == true) {
    background(255, 0, 0);
    fill(255, 255, 0);
    x = x + (mouseX - x) / 20.0;
    y = y + (mouseY - y) / 20.0;
  }

  if (kyori < r) {
    circle(x + random(-10, 10), y + random(-10, 10), r * 2);
  } else {
    circle(x, y, r * 2);
  }
}

function mousePressed() {
  //マウスのボタンが押し下げられた時の処理
  dragging = false;
  let kyori = dist(x, y, mouseX, mouseY);
  if (kyori < r) {
    dragging = true; //draggingをtrueに変える
  }
}

function mouseReleased() {
  //マウスのボタンが離された時の処理
  dragging = false;
}

function keyPressed() {
  if (key == "s") {
    saveCanvas();
  }
}
