let num = 100;
let x = new Array(num);
let y = new Array(num);

function setup() {
  createCanvas(600, 600); //ウィンドウサイズの指定
  background(0, 0, 0); //背景色を指定して1回だけ塗る。
  for (let i = 0; i < num; i++) {
    x[i] = width / 2;
    y[i] = height / 2;
  }
}

function draw() {
  background(0, 0, 0);
  for (let i = 0; i < num; i = i + 1) {
    noFill();
    stroke(255 - i * 3, i * 2, i * 3, 150);
    circle(x[i], y[i], i * 9);
    if (i == 0) {
      x[i] = x[i] + (mouseX - x[i]) / 10.0;
      y[i] = y[i] + (mouseY - y[i]) / 10.0;
    } else {
      x[i] = x[i] + (x[i - 1] - x[i]) / 10.0;
      y[i] = y[i] + (y[i - 1] - y[i]) / 10.0;
    }
  }
}

function mousePressed() {
  //マウスのボタンが押し下げられた時の処理
}

function mouseReleased() {
  //マウスのボタンが離された時の処理
}

function keyPressed() {
  if (key == "s") {
    saveCanvas();
  }
}
