function setup() {
  createCanvas(600, 600); //ウィンドウサイズの指定
  background(100, 100, 255); //背景色を指定して1回だけ塗る。
  stroke(255, 255, 255); //線の色を指定
  line(100, 100, 500, 500); //直線を描く
  line(300, 100, 300, 500);

  fill(255, 255, 100); //塗りの色を指定
  noStroke(); //線を「なし」にする
  circle(400, 200, 200); //円を描く

  noFill(); //塗りを「なし」にする
  stroke(0, 255, 0); //線の色を指定
  rect(100, 400, 100, 100); //長方形を描く

  ellipse(200, 300, 300, 100); //楕円を描く

  triangle(400, 400, 500, 450, 350, 550); //三角形を描く

  bezier(50, 200, 300, 100, 400, 500, 550, 300); //ベジェ曲線を描く

  fill(255, 0, 0);
  angleMode(DEGREES);
  arc(300, 300, 500, 500, 60, 120, PIE); //円弧を描く

  beginShape(); //多角形を描き始める
  vertex(200, 100); //頂点を増やす
  vertex(300, 200); //頂点を増やす
  vertex(250, 300); //頂点を増やす
  vertex(100, 300); //頂点を増やす
  vertex(100, 200); //頂点を増やす
  endShape(CLOSE); //多角形を描き終える
}

function draw() {
  // background(0, 0, 0); //背景色を指定して1回だけ塗る。
}

function mousePressed() {
  //マウスのボタンが押し下げられた時の処理
}

function mouseReleased() {
  //マウスのボタンが離された時の処理
}

function keyPressed() {
  if (key == "s") {
    saveCanvas();
  }
}
