function setup() {
  createCanvas(600, 600); //ウィンドウサイズの指定
  background(255, 0, 0); //背景色を指定して1回だけ塗る。
  stroke(255, 255, 0);
  line(100, 100, 500, 500);
  fill(255, 255, 100);
  circle(200, 200, 100); //縁を描く
  noFill(); //輪郭を無しにする
  circle(270, 270, 100);
  circle(340, 340, 100);
  stroke(255, 255, 0);
  noFill(); //塗りなし
  rect(50, 150, 400, 400);

  ellipse(200, 400, 300, 100); //楕円を描く

  stroke(200, 250, 200);
  noFill();
  triangle(40, 40, 550, 50, 20, 550); //三角形を描く
  bezier(10, 150, 400, 450, 400, 450, 20, 400); //曲線を描く
  angleMode(DEGREES); //
  arc(300, 300, 500, 500, 0, 30, PIE); //円弧を描く(x,y,x',y',開始角度,終了角度,半径の輪郭線)

  beginShape(); //多角形を描き始める
  vertex(200, 100); //頂点を増やす
  vertex(300, 200); //頂点を増やす
  vertex(250, 300); //頂点を増やす
  vertex(100, 300); //頂点を増やす
  vertex(100, 200); //頂点を増やす
  endShape(CLOSE); //多角形を描き終える(線を繋げる)
}

function draw() {
  // background(0, 0, 0); //背景色を指定して1回だけ塗る。
}

function mousePressed() {
  //マウスのボタンが押し下げられた時の処理
}

function mouseReleased() {
  //マウスのボタンが離された時の処理
}

function keyPressed() {
  if (key == "s") {
    saveCanvas();
  }
}
