function setup() {
  createCanvas(400, 400); // キャンバスを作成
}

function draw() {
  background(220); // 背景色を設定

  // カラフルな猫を描く
  drawCat(width / 2, height / 2, 100); // 猫の位置をキャンバスの中心に設定
}

function drawCat(x, y, size) {
  // 猫の体
  let bodyColor = color(random(255), random(255), random(255)); // ランダムな色を生成
  fill(bodyColor); // ランダムな色で塗りつぶし
  ellipse(x, y + size / 2, size, size); // 体

  // 猫の顔
  let faceColor = color(random(255), random(255), random(255)); // ランダムな色を生成
  fill(faceColor); // ランダムな色で塗りつぶし
  ellipse(x, y, size * 0.8, size * 0.8); // 顔

  // 猫の目
  fill(0); // 色を黒に設定
  ellipse(x - size / 4, y - size / 8, size / 4, size / 4); // 左目
  ellipse(x + size / 4, y - size / 8, size / 4, size / 4); // 右目

  // 猫の鼻
  fill(255, 100, 100); // 色をピンクに設定
  ellipse(x, y + size / 8, size / 10, size / 10); // 鼻

  // 猫の口
  noFill(); // 塗りつぶしをなしに設定
  stroke(0); // 線の色を黒に設定
  arc(x, y + size / 6, size * 0.4, size * 0.2, 0, PI); // 口
}

function mousePressed() {
  //マウスのボタンが押し下げられた時の処理
}

function mouseReleased() {
  //マウスのボタンが離された時の処理
}

function keyPressed() {
  if (key == "s") {
    saveCanvas();
  }
}
