function setup() {
  createCanvas(400, 400); // キャンバスを作成
}

function draw() {
  background(220); // 背景色を設定

  // リアルな色合いの猫を描く
  drawCat(width / 2, height / 2, 100); // 猫の位置をキャンバスの中心に設定
}

function drawCat(x, y, size) {
  // 猫の体
  fill(135, 91, 77); // リアルな茶色
  ellipse(x, y + size / 2, size, size); // 体

  // 耳
  fill(135, 91, 77); // リアルな茶色
  triangle(
    x - size * 0.2,
    y - size * 0.5,
    x + size * 0.2,
    y - size * 0.5,
    x,
    y - size * 0.8,
  ); // 左耳
  triangle(
    x - size * 0.2 + size,
    y - size * 0.5,
    x + size * 0.2 + size,
    y - size * 0.5,
    x + size,
    y - size * 0.8,
  ); // 右耳

  // 猫の顔
  fill(205, 155, 126); // リアルな肌色
  ellipse(x, y, size * 0.8, size * 0.8); // 顔

  // 猫の目
  fill(255); // 白色
  ellipse(x - size / 4, y - size / 8, size / 8, size / 8); // 左目
  ellipse(x + size / 4, y - size / 8, size / 8, size / 8); // 右目
  fill(0); // 黒色
  ellipse(x - size / 4, y - size / 8, size / 16, size / 16); // 左目の瞳孔
  ellipse(x + size / 4, y - size / 8, size / 16, size / 16); // 右目の瞳孔

  // 猫の鼻
  fill(179, 114, 92); // リアルなピンク
  ellipse(x, y + size / 8, size / 10, size / 10); // 鼻

  // 猫の口
  noFill(); // 塗りつぶしをなしに設定
  stroke(0); // 線の色を黒に設定
  arc(x, y + size / 6, size * 0.4, size * 0.2, 0, PI); // 口
}

function mousePressed() {
  //マウスのボタンが押し下げられた時の処理
}

function mouseReleased() {
  //マウスのボタンが離された時の処理
}

function keyPressed() {
  if (key == "s") {
    saveCanvas();
  }
}
