function setup() {
  createCanvas(400, 400);
  background(220);
  drawFace(width / 2, height / 2, 200);
}

function drawFace(x, y, size) {
  // 顔の円
  fill(255, 230, 200); // 顔の色
  ellipse(x, y, size, size);

  // 目
  fill(0); // 目の色
  ellipse(x - size / 5, y - size / 10, size / 10, size / 10); // 左目
  ellipse(x + size / 5, y - size / 10, size / 10, size / 10); // 右目

  // 口
  noFill();
  strokeWeight(2);
  arc(x, y + size / 10, size / 4, size / 6, 0, PI); // 口

  // 鼻
  fill(255, 150, 150); // 鼻の色
  triangle(x, y, x - size / 20, y + size / 20, x + size / 20, y + size / 20); // 鼻

  // 影
  fill(0, 50); // 影の色
  ellipse(x + size / 5, y + size / 4, size / 4, size / 6); // 右側の影
  ellipse(x - size / 5, y + size / 4, size / 4, size / 6); // 左側の影

  // ハイライト
  fill(255, 200); // ハイライトの色
  ellipse(x - size / 10, y - size / 6, size / 10, size / 10); // 左側のハイライト
  ellipse(x + size / 10, y - size / 6, size / 10, size / 10); // 右側のハイライト
}

function mousePressed() {
  //マウスのボタンが押し下げられた時の処理
}

function mouseReleased() {
  //マウスのボタンが離された時の処理
}

function keyPressed() {
  if (key == "s") {
    saveCanvas();
  }
}
